<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCountriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('countries', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->text('country_name');
            $table->text('slug');
            $table->text('currency');
            $table->text('user_id');
            $table->text('country_id');
            $table->text('country_manager');
            $table->text('features_flag')->nullable();
            $table->text('status');
            $table->text('features_manager')->nullable();
            $table->text('currency_rate')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('countries');
    }
}
