# condense-newlines [![NPM version](https://img.shields.io/npm/v/condense-newlines.svg?style=flat)](https://www.npmjs.com/package/condense-newlines) [![NPM downloads](https://img.shields.io/npm/dm/condense-newlines.svg?style=flat)](https://npmjs.org/package/condense-newlines) [![Build Status](https://img.shields.io/travis/jonschlinkert/condense-newlines.svg?style=flat)](https://travis-ci.org/jonschlinkert/condense-newlines)

Replace extraneous newlines with a single newline, or pass a specified number of newlines to use.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install condense-newlines --save
```

## Usage

```js
var condense = require('condense-newlines');
console.log(condense('\n\na\n\n\nb\nc\r\n\r\nd\n\n\n'));
//=> '\na\nb\nc\nd\n';
```

## Options

### options.sep

Specify the separator to use

```js
console.log(condense('\n\na\n\n\nb\nc\r\n\r\nd\n\n\n', {sep: '\n\n'}));
//=> '\n\na\n\nb\n\nc\n\nd\n\n';
```

### options.min

The minimum number of consecutive newlines to condense.

**Default**

: `2`

```js
console.log(condense('\n\na\n\n\nb\nc\r\n\r\nd\n\n\n', {min: 2}));
//=> '\n\na\n\nb\n\nc\n\nd\n\n';
```

### options.keepWhitespace

Don't treat whitespace-only lines as newlines.

```js
console.log(condense('\n\na\n\n      \nb\nc\r\n\r\nd\n\n\n', {
  keepWhitespace: true, sep: '\n\n'
}));

//=> '\n\na\n\n      \nb\n\nc\n\nd\n\n';
```

## Related projects

You might also be interested in these projects:

* [arr-union](https://www.npmjs.com/package/arr-union): Combines a list of arrays, returning a single array with unique values, using strict equality… [more](https://www.npmjs.com/package/arr-union) | [homepage](https://github.com/jonschlinkert/arr-union)
* [array-unique](https://www.npmjs.com/package/array-unique): Return an array free of duplicate values. Fastest ES5 implementation. | [homepage](https://github.com/jonschlinkert/array-unique)
* [arrayify-compact](https://www.npmjs.com/package/arrayify-compact): Casts the given value to a flatten array, and removes falsey items (similar to lodash… [more](https://www.npmjs.com/package/arrayify-compact) | [homepage](https://github.com/jonschlinkert/arrayify-compact)

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/condense-newlines/issues/new).

## Building docs

Generate readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install verb && npm run docs
```

Or, if [verb](https://github.com/verbose/verb) is installed globally:

```sh
$ verb
```

## Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

## Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/condense-newlines/blob/master/LICENSE).

***

_This file was generated by [verb](https://github.com/verbose/verb), v0.9.0, on April 23, 2016._