<?php if($user->trashed()): ?>
    <div class="btn-group" role="group" aria-label="<?php echo app('translator')->get('labels.backend.access.users.user_actions'); ?>">
        <a href="<?php echo e(route('admin.auth.user.restore', $user)); ?>" name="confirm_item" class="btn btn-info" data-toggle="tooltip" data-placement="top" title="<?php echo app('translator')->get('buttons.backend.access.users.restore_user'); ?>">
            <i class="fas fa-sync"></i>
        </a>

        <a href="<?php echo e(route('admin.auth.user.delete-permanently', $user)); ?>" name="confirm_item" class="btn btn-danger" data-toggle="tooltip" data-placement="top" title="<?php echo app('translator')->get('buttons.backend.access.users.delete_permanently'); ?>">
            <i class="fas fa-trash"></i>
        </a>
    </div>
<?php else: ?>
    <div class="btn-group" role="group" aria-label="<?php echo app('translator')->get('labels.backend.access.users.user_actions'); ?>">
        <a href="<?php echo e(route('admin.auth.user.show', $user)); ?>" data-toggle="tooltip" data-placement="top" title="<?php echo app('translator')->get('buttons.general.crud.view'); ?>" class="btn btn-info">
            <i class="fas fa-eye"></i>
        </a>

        <a href="<?php echo e(route('admin.auth.user.edit', $user)); ?>" data-toggle="tooltip" data-placement="top" title="<?php echo app('translator')->get('buttons.general.crud.edit'); ?>" class="btn btn-primary">
            <i class="fas fa-edit"></i>
        </a>

        <div class="btn-group btn-group-sm" role="group">
            <button id="userActions" type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <?php echo app('translator')->get('labels.general.more'); ?>
            </button>
            <div class="dropdown-menu" aria-labelledby="userActions">
                <?php if($user->id !== auth()->id()): ?>
                    <a href="<?php echo e(route('admin.auth.user.clear-session', $user)); ?>"
                       data-trans-button-cancel="<?php echo app('translator')->get('buttons.general.cancel'); ?>"
                       data-trans-button-confirm="<?php echo app('translator')->get('buttons.general.continue'); ?>"
                       data-trans-title="<?php echo app('translator')->get('strings.backend.general.are_you_sure'); ?>"
                       class="dropdown-item" name="confirm_item"><?php echo app('translator')->get('buttons.backend.access.users.clear_session'); ?></a>
                <?php endif; ?>

                <?php if (can_be_impersonated($user)) : ?>
                    <a href="<?php echo e(route('impersonate', $user->id)); ?>" class="dropdown-item"><?php echo app('translator')->get('buttons.backend.access.users.login_as', ['user' => $user->full_name]); ?></a>
                <?php endif; ?>

                <a href="<?php echo e(route('admin.auth.user.change-password', $user)); ?>" class="dropdown-item"><?php echo app('translator')->get('buttons.backend.access.users.change_password'); ?></a>

                <?php if($user->id !== auth()->id()): ?>
                    <?php switch($user->active):
                        case (0): ?>
                            <a href="<?php echo e(route('admin.auth.user.mark', [$user, 1,])); ?>" class="dropdown-item"><?php echo app('translator')->get('buttons.backend.access.users.activate'); ?></a>
                        <?php break; ?>

                        <?php case (1): ?>
                            <a href="<?php echo e(route('admin.auth.user.mark', [$user, 0])); ?>" class="dropdown-item"><?php echo app('translator')->get('buttons.backend.access.users.deactivate'); ?></a>
                        <?php break; ?>
                    <?php endswitch; ?>
                <?php endif; ?>

                <?php if(! $user->isConfirmed() && ! config('access.users.requires_approval')): ?>
                    <a href="<?php echo e(route('admin.auth.user.account.confirm.resend', $user)); ?>" class="dropdown-item"><?php echo app('translator')->get('buttons.backend.access.users.resend_email'); ?></a>
                <?php endif; ?>

                <?php if($user->id !== 1 && $user->id !== auth()->id()): ?>
                    <a href="<?php echo e(route('admin.auth.user.destroy', $user)); ?>"
                       data-method="delete"
                       data-trans-button-cancel="<?php echo app('translator')->get('buttons.general.cancel'); ?>"
                       data-trans-button-confirm="<?php echo app('translator')->get('buttons.general.crud.delete'); ?>"
                       data-trans-title="<?php echo app('translator')->get('strings.backend.general.are_you_sure'); ?>"
                       class="dropdown-item"><?php echo app('translator')->get('buttons.general.crud.delete'); ?></a>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/cxc/public_html/tprmap.com/resources/views/backend/auth/user/includes/actions.blade.php ENDPATH**/ ?>