<?php $__env->startSection('title', app_name() . ' | ' . __('navs.general.home')); ?>



<?php $__env->startSection('content'); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<script src="<?php echo e(url('js/jquery-3.4.1.min.js')); ?>"></script>
<style>
.gm-style-iw-d{
    max-height: 254px !important;

}

body {
    font-family: 'Roboto Condensed', sans-serif;
    background-color: #f5f5f5
}

.hedding {
    font-size: 20px;
    color: #ab8181`;
}

.main-section {
    position: absolute;
    left: 50%;
    right: 50%;
    transform: translate(-50%, 5%);
}

.left-side-product-box img {
    width: 100%;
}

.left-side-product-box .sub-img img {
    margin-top: 5px;
    width: 83px;
    height: 100px;
}

.right-side-pro-detail span {
    font-size: 15px;
}

.right-side-pro-detail p {
    font-size: 25px;
    color: #a1a1a1;
}

.right-side-pro-detail .price-pro {
    color: #E45641;
}

.right-side-pro-detail .tag-section {
    font-size: 18px;
    color: #5D4C46;
}

.pro-box-section .pro-box img {
    width: 100%;
    height: 200px;
}

@media (min-width:360px) and (max-width:640px) {
    .pro-box-section .pro-box img {
        height: auto;
    }
}

#cover-spin {
    position:fixed;
    width:100%;
    left:0;right:0;top:0;bottom:0;
    background-color: rgba(255,255,255,0.7);
    z-index:9999;
    display:none;
}

@-webkit-keyframes spin {
	from {-webkit-transform:rotate(0deg);}
	to {-webkit-transform:rotate(360deg);}
}

@keyframes  spin {
	from {transform:rotate(0deg);}
	to {transform:rotate(360deg);}
}

#cover-spin::after {
    content:'';
    display:block;
    position:absolute;
    left:48%;top:40%;
    width:40px;height:40px;
    border-style:solid;
    border-color:black;
    border-top-color:transparent;
    border-width: 4px;
    border-radius:50%;
    -webkit-animation: spin .8s linear infinite;
    animation: spin .8s linear infinite;
}
</style>

<div id="cover-spin"></div>

<!-- banner -->
<section id="index-banner">
    <?php if($country->home_banner == null): ?>
        <div class="container-fluid banner" style="background-image: url( <?php echo e(url('tpr_templete/images/index_banner.png' )); ?> );">
        </div>
    <?php else: ?>
        <div class="container-fluid banner" style="background-image: url( <?php echo e(url( uploaded_asset($country->home_banner) )); ?> );">
        </div>
    <?php endif; ?>
</section>


<!--search-->
<section id="index-search" class="container-fluid search" style="background: rgba(255, 255, 255, .5)">
    <?php echo $__env->make('frontend.includes.search_bar',[
            'category_type' => 'category_type'
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</section>




<?php if(get_country_cookie(request())): ?>

<?php if(App\Models\HomePageAdvertisement::where('country',get_country_cookie(request())->country_name)->where('status','=','Enable')->where('category','!=',null)->where('admin_approval','=','Approved')->where('country_manager_approval','=','Approved')->first() == null): ?>

<?php else: ?>
<!--recent projects-->
<section id="index-recent-projects">

    <div class="container-fluid p-3 text-center text-white" style="background-color: #156073">
        <h3 class="fw-bolder" data-aos="fade-up" data-aos-duration="500">Property Market in
            <?php echo e(get_country_cookie(request())->country_name); ?></h3>
    </div>

    <div class="container text-center p-0 mt-3" data-aos="fade-up" data-aos-duration="500">
        <ul class="nav mb-3 justify-content-center" id="projects-tab" role="tablist">
            <li class="nav-item project-item" role="presentation" data-aos="fade-up" data-aos-duration="500"
                data-aos-delay="150">
                <a class="nav-link active tabs" id="all-tab" data-bs-toggle="tab" data-bs-target="#tab-all"
                    type="button" role="tab" aria-controls="tabs-all" aria-selected="true">All</a>
            </li>

            <?php $__currentLoopData = $ad_category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $ad_cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <?php if(get_country_cookie(request())->country_name == $ad_cat->country): ?>

            <?php if(App\Models\HomePageAdvertisement::where('category',$ad_cat->id)->where('admin_approval','=','Approved')->where('country_manager_approval','=','Approved')->where('status','=','Enable')->first()
            == null): ?>

            <?php else: ?>
            <li class="nav-item project-item" role="presentation" data-aos="fade-up" data-aos-duration="500"
                data-aos-delay="300">
                <a class="nav-link tabs" id="tab-id<?php echo e($ad_cat->id); ?>" data-bs-toggle="tab"
                    data-bs-target="#tab<?php echo e($ad_cat->id); ?>" type="button" role="tab"
                    aria-controls="tab-<?php echo e($ad_cat->id); ?>" aria-selected="false"><?php echo e($ad_cat->name); ?></a>
            </li>

            <?php endif; ?>

            <?php endif; ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </ul>

        <div class="tab-content mt-md-5 py-0" id="tabs-tabContent">

            <div class="tab-pane fade show active" id="tab-all" role="tabpanel" aria-labelledby="all-tab">

                <div class="swiper container mySwiper">
                    <div class="swiper-wrapper">

                        <?php $__currentLoopData = $homepage_ad; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $home_ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <?php if(get_country_cookie(request())->country_name == $home_ad->country): ?>

                        <div class="swiper-slide">
                            <img src="<?php echo e(url('files/homepage_advertisement',$home_ad->image)); ?>" class="img-fluid" alt=""
                                style="object-fit:cover; height: 210px;" data-bs-toggle="modal"
                                data-bs-target="#ad-modal">
                            <input type="hidden" value="<?php echo e($home_ad->link); ?>" class="ad-link">
                            <input type="hidden" value="<?php echo e($home_ad->description); ?>" class="ad-description">
                        </div>

                        <?php endif; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                    <div class="swiper-pagination"></div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>

            </div>

            <?php $__currentLoopData = $ad_category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $ad_cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="tab-pane fade" id="tab<?php echo e($ad_cat->id); ?>" role="tabpanel"
                aria-labelledby="tab-id<?php echo e($ad_cat->id); ?>">
                <div class="swiper container mySwiper2">
                    <div class="swiper-wrapper">

                        <?php $__currentLoopData = App\Models\HomePageAdvertisement::where('category',$ad_cat->id)->where('status','=','Enable')->where('admin_approval','=','Approved')->where('country_manager_approval','=','Approved')->orderBy('order','ASC')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <div class="swiper-slide">
                            <img src="<?php echo e(url('files/homepage_advertisement',$data->image)); ?>" class="img-fluid" alt=""
                                style="object-fit:cover; height: 210px;" data-bs-toggle="modal"
                                data-bs-target="#ad-modal">
                            <input type="hidden" value="<?php echo e($data->link); ?>" class="ad-link">
                            <input type="hidden" value="<?php echo e($data->description); ?>" class="ad-description">
                        </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                    <div class="swiper-pagination"></div>

                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
    </div>
</section>

<?php endif; ?>

<?php else: ?>

<h1 class="mobile-mt-30" align="center">Select a Country</h1>

<?php endif; ?>



<!-- Ad Modal -->
<div class="modal fade" id="ad-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <!-- <h5 class="modal-title" id="exampleModalLabel">Modal title</h5> -->
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-12">
                        <img src="" alt="" id="modal-ad-img" class="img-fluid w-100"
                            style="object-fit: cover; height: 20rem">
                        <!-- <input name="description" id="modal-ad-description" class="form-control mt-3"></input> -->
                        <p class="mt-3" id="modal-ad-description" style="text-align: justify;"></p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <a href="" type="button" class="btn btn-primary" id="modal-ad-link" target="_blank">More Details</a>
            </div>
        </div>
    </div>
</div>





<!--property search-->
<section id="index-property-search">
    <div class="container-fluid mobile-mt-15" style="margin-top:4rem">
        <h3 class="fw-bolder text-center" data-aos="fade-up" data-aos-duration="500">Interactive Property Search</h3>
        <div class="row mt-4">
            <?php if(count($promo) > 0): ?>
            <div class="col-12 col-md-3 mb-4 mb-md-0 tab-35" style="background-color: #F3F3F3">
                <h6 data-aos="fade-right" data-aos-duration="500" data-aos-delay="200">Results: <?php echo e(count($promo)); ?>

                    Listings</h6>
                <div class="row align-items-center" data-aos="fade-right" data-aos-duration="500" data-aos-delay="400">
                    <div class="col-5">
                        <!-- <p class="mb-0 text">Sort By</p> -->
                    </div>
                    <div class="col-7">
                        <div class="dropdown">
                            <button class="btn btn-light dropdown-toggle w-100" type="button" id="dropdownMenuButton1"
                                data-bs-toggle="dropdown" aria-expanded="false">
                                Sorting
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                <li><a href="<?php echo e(route('frontend.search_function', ['key_name', 'min_price', 'max_price', 'category_type', 'transaction_type', 'property_type', 'beds', 'baths', 'land_size', 'listed_since', 'building_type', 'open_house', 'zoning_type', 'units', 'building_size', 'farm_type', 'parking_type', 'city', 'long', 'lat', 'area_coordinator', 'external_keyword', 'description_key_name', 'newest'] )); ?>" class="dropdown-item">Newest</a></li>
                                <li><a href="<?php echo e(route('frontend.search_function', ['key_name', 'min_price', 'max_price', 'category_type', 'transaction_type', 'property_type', 'beds', 'baths', 'land_size', 'listed_since', 'building_type', 'open_house', 'zoning_type', 'units', 'building_size', 'farm_type', 'parking_type', 'city', 'long', 'lat', 'area_coordinator', 'external_keyword', 'description_key_name', 'oldest'] )); ?>" class="dropdown-item">Oldest</a></li>
                                <li><a href="<?php echo e(route('frontend.search_function', ['key_name', 'min_price', 'max_price', 'category_type', 'transaction_type', 'property_type', 'beds', 'baths', 'land_size', 'listed_since', 'building_type', 'open_house', 'zoning_type', 'units', 'building_size', 'farm_type', 'parking_type', 'city', 'long', 'lat', 'area_coordinator', 'external_keyword', 'description_key_name', 'low_price'] )); ?>" class="dropdown-item">Low Price</a></li>
                                <li><a href="<?php echo e(route('frontend.search_function', ['key_name', 'min_price', 'max_price', 'category_type', 'transaction_type', 'property_type', 'beds', 'baths', 'land_size', 'listed_since', 'building_type', 'open_house', 'zoning_type', 'units', 'building_size', 'farm_type', 'parking_type', 'city', 'long', 'lat', 'area_coordinator', 'external_keyword', 'description_key_name', 'high_price'] )); ?>" class="dropdown-item">High Price</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="properties">
                    <?php $__currentLoopData = $promo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row border align-items-center p-1">
                        <div class="col-6">
                            <a href="<?php echo e(route('frontend.individual-property', $property->id)); ?>"><img data-id="<?php echo e($property->id); ?>" src="<?php echo e(url('image_assest', $property->feature_image_id)); ?>" onmouseover="bigImg('<?php echo e($property->id); ?>')" alt="" class="img-fluid imgmap" style="height: 90px!important; object-fit: cover!important; width: 100%;"></a>
                        </div>
                        <div class="col-6">
                            <div class="row">
                                <div class="col-7">
                                    <p class="mb-0 small-num" style="margin-top:10px; font-size: 0.8rem;">2021-08-25</p>
                                </div>
                                <div class="col-5">
                                    <!-- <a class="heart-fix-a" href="<?php echo e(route('frontend.individual-property', $property->id)); ?>" style="text-decoration:none;"> -->
                                        <?php if(auth()->guard()->check()): ?>
                                            <?php if(is_favorite($property->id, auth()->user()->id)): ?>
                                                <div class="col-4 small-heart">
                                               
                                                            <input type="hidden" id="favourite" class="favourite" name='favourite' value="favourite">
                                                            <input type="hidden" id="unfavourite" class="favourite" name='favourite' value="non-favourite">
                                                            <button  id="unsave" data-id="<?php echo e($property->id); ?>" class="bi bi-heart-fill border-0 unsave" type="submit" style="font-size: 1rem; display: block; color: #ff0000; background-color: transparent;"></button>
                                                            <button    id="save" data-id="<?php echo e($property->id); ?>" class="bi bi-heart border-0 save" type="submit" style="margin-left: 6px; font-size: 1rem; display: none; color: #ff0000; background-color: transparent;"></button>
                                                  
                                                </div>
                                            <?php else: ?>
                                                        
                                                <div class="col-4 small-heart">
                                                    
                                                             <input type="hidden" id="unfavourite" class="favourite" name='favourite' value="non-favourite">
                                                            <input type="hidden" id="favourite" class="favourite" name='favourite' value="favourite">
                                                            <button id="save" data-id="<?php echo e($property->id); ?>" class="bi bi-heart border-0 save" type="submit" style="margin-left: 6px; font-size: 1rem; display: block; color: #ff0000; background-color: transparent;"></button>
                                                            <button  id="unsave" data-id="<?php echo e($property->id); ?>" class="bi bi-heart-fill border-0 unsave" type="submit" style="font-size: 1rem; display: none; color: #ff0000; background-color: transparent;"></button>
                                                </div>
                                            <?php endif; ?>
                                        <?php else: ?>       
                                            <?php if(is_favorite_cookie($property->id)): ?> 
                                                <div class="col-4 small-heart">
                                                    <a href="<?php echo e(url('favourite_cookie_properties/remove',$property->id)); ?>" class="bi bi-heart-fill border-0 heart-without-form" style="text-decoration:none; font-size: 1rem; display: block; color: #ff0000; background-color: transparent;"></a>
                                                </div>    
                                            <?php else: ?>
                                                <div class="col-4 small-heart">
                                                    <form action="<?php echo e(route('frontend.favourite_cookie.store')); ?>" method="post" enctype="multipart/form-data">
                                                    <?php echo e(csrf_field()); ?>

                                                        <input type="hidden" name="cookie_property_id" value="<?php echo e($property->id); ?>" />
                                                        <button class="bi bi-heart border-0" type="submit" style="font-size: 1rem; display: block; color: #ff0000; background-color: transparent;"></button>
                                                    </form>                                                        
                                                </div>                                                        
                                            <?php endif; ?>                                                  
                                                    
                                        <?php endif; ?>
                                    </a>
                                </div>

                                <p class="fw-bold mb-0"><?php echo e($property->name); ?></p>
                                <p class="mb-0" style="font-size: 0.8rem;">Transaction Type: <?php echo e($property->transaction_type); ?></p>
                                <p class="mb-0" style="font-size: 0.8rem;">Country: <?php echo e($property->country); ?></p>

                                <?php if(get_country_cookie(request())): ?>
                                    <p class="mb-0 d-inline-block px-2 py-1 mt-2 text-light mb-1" style="font-size: 0.8rem; background: #4195e1; border-radius: 7px;">
                                    <?php echo e(current_price(request(), get_country_cookie(request())->country_id, $property->price)); ?></p>
                                <?php else: ?>
                                    <p class="mb-0 d-inline-block px-2 py-1 mt-2 text-light mb-1" style="font-size: 0.8rem; background: #4195e1; border-radius: 7px;">
                                    <?php echo e(current_price(request(), 1, $property->price)); ?></p>
                                <?php endif; ?>

                            </div>   
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php else: ?>
            <div class="col-12 col-md-3 mb-4 mb-md-0 tab-35">
                <div class="">
                    <div class="no-result border py-2 px-3">
                        <h4 class="text-center">No Results</h4>
                        <p class="ns mb-1">Please refine your search criteria.</p>
                        <p class="ns">Suggestions:</p>

                        <ul>
                            <li class="no-result-list">Modify your search criteria</li>
                            <li class="no-result-list">Update your search location</li>
                            <li class="no-result-list">Broaden your map area</li>
                            <li class="no-result-list">Modify your keywords</li>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <div class="col-12 col-md-9 p-md-0 tab-65">
                <div id="map" style="height: 600px; width: 100%;"></div>
            </div>
        </div>
    </div>
</section>

<!--cards-->
<section id="index-cards">
    <div class="container mt-5">
        <div class="row">
            <div class="col-12 col-md-4 mb-4 mb-md-0" data-aos="fade-up" data-aos-duration="500" data-aos-delay="100">
                <a href="<?php echo e(route('frontend.search_function', ['key_name', 'min_price', 'max_price', 'residential', 'transaction_type', 'property_type', 'beds', 'baths', 'land_size', 'listed_since', 'building_type', 'open_house', 'zoning_type', 'units', 'building_size', 'farm_type', 'parking_type', 'city', 'long', 'lat', 'area_coordinator', 'external_keyword', 'description_key_name', 'sorting'] )); ?>" style="text-decoration: none;">
                    <div class="card p-4 custom-shadow border-0 home-card">
                        <img src="<?php echo e(url('tpr_templete/images/card_1.svg')); ?>" class="card-img-top" alt="..." height="200rem">
                        <div class="card-body mt-4 p-2">
                            <h4 class="card-title text-center mb-4">Map Search</h4>

                            <!-- <h5 class="text-info">Draw your map Options</h5> -->
                            <p class="card-text">Broaden your view on different localities using the unique Map Search
                                option available on our site. Access to your preferred locations and properties is just a
                                click away.</p>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-12 col-md-4 mb-4 mb-md-0" data-aos="fade-up" data-aos-duration="500" data-aos-delay="300">
               <a href="<?php echo e(route('frontend.search_function', ['key_name', 'min_price', 'max_price', 'residential', 'transaction_type', 'property_type', 'beds', 'baths', 'land_size', 'listed_since', 'building_type', 'open_house', 'zoning_type', 'units', 'building_size', 'farm_type', 'parking_type', 'city', 'long', 'lat', 'area_coordinator', 'external_keyword', 'description_key_name', 'sorting'] )); ?>" style="text-decoration: none;">
                   <div class="card p-4 custom-shadow border-0 home-card">
                       <img src="<?php echo e(url('tpr_templete/images/card_2.svg')); ?>" class="card-img-top" alt="..." height="200rem">
                       <div class="card-body mt-4 p-2">
                           <h4 class="card-title text-center mb-4">Properties Near Me</h4>
                           <!-- <h5 class="text-info">SubTopic</h5> -->
                           <p class="card-text">Got your eye on a preferred location? Use our site to look for properties
                               near your vicinity that will appeal to your budget and preference.</p>
                       </div>
                   </div>
               </a>

            </div>
            <?php if(auth()->guard()->check()): ?>
            <div class="col-12 col-md-4" data-aos="fade-up" data-aos-duration="500" data-aos-delay="500">
                <a href="<?php echo e(route('frontend.user.user_notifications')); ?>" style="text-decoration: none;">

                    <div class="card p-4 custom-shadow border-0 home-card">
                        <img src="<?php echo e(url('tpr_templete/images/card_3.svg')); ?>" class="card-img-top" alt="..." height="200rem">
                        <div class="card-body mt-4 p-2">
                            <h4 class="card-title text-center mb-4">Property Alerts</h4>
                            <!-- <h5 class="text-info">SubTopic</h5> -->
                            <p class="card-text">Register with us and get regular updates and insights about the properties
                                and real estate market in your preferred locations.</p>
                        </div>
                    </div>
                </a>

            </div>

            <?php else: ?>

                    <div class="col-12 col-md-4" data-aos="fade-up" data-aos-duration="500" data-aos-delay="500">
                        <a href="<?php echo e(route('frontend.auth.register')); ?>" style="text-decoration: none;">

                        <div class="card p-4 custom-shadow border-0 home-card">
                            <img src="<?php echo e(url('tpr_templete/images/card_3.svg')); ?>" class="card-img-top" alt="..." height="200rem">
                            <div class="card-body mt-4 p-2">
                                <h4 class="card-title text-center mb-4">Property Alerts Live</h4>
                                <!-- <h5 class="text-info">SubTopic</h5> -->
                                <p class="card-text">Register with us and get regular updates and insights about the properties
                                    and real estate market in your preferred locations.</p>
                            </div>
                        </div>
                        </a>

                    </div>
            <?php endif; ?>

        </div>
    </div>
</section>


<!--featured projects-->
<section id="index-featured-projects">
    <div class="container " style="margin-top:7rem">
        <?php if(count($latest) != 0): ?>

        <h3 class="text-center fw-bolder" data-aos="fade-up" data-aos-duration="500">Featured Properties</h3>

        <div class="mt-4 mt-md-5">
            <h4 data-aos="fade-up" data-aos-duration="500" data-aos-delay="100">Fresh in the Market</h4>

            <div class="row mt-4">

                <?php $__currentLoopData = $latest; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <div class="col-12 col-md-4 mb-4 mb-md-0" data-aos="flip-right" data-aos-duration="500"
                    data-aos-delay="200">
                    <div class="card p-4 custom-shadow border-0 tab-card-height" style="height:24.5rem">
                        <a href="<?php echo e(route('frontend.individual-property', $lat->id)); ?>"><img
                                src="<?php echo e(url('image_assest',$lat->feature_image_id)); ?>" class="card-img-top w-100"
                                alt="..." style="object-fit:cover; height:210px;"></a>
                        <div class="card-body">

                            <h5 class="card-title"><?php echo e($lat->name); ?></h5>

                            <?php if($lat->beds != null): ?>
                            <p class="card-text mt-3 mb-1"><?php echo e($lat->beds); ?> Beds Semidetached house</p>
                            <?php endif; ?>

                            <p class="card-text"><?php echo e($lat->city); ?>, <?php echo e($lat->country); ?></p>

                            <?php if(get_country_cookie(request())): ?>
                            <p class="mt-1 text-info">
                                <?php echo e(current_price(request(), get_country_cookie(request())->country_id, $lat->price)); ?></p>

                            <?php else: ?>
                            <p class="mt-1 text-info"><?php echo e(current_price(request(), 1, $lat->price)); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php else: ?>

        <?php endif; ?>



        <?php if(json_decode($country->features_manager) != null): ?>
        <?php if(json_decode($country->features_manager)[0]->properties != null): ?>

        <div class="home-featured" style="margin-top: 6rem">

            <h4 data-aos="fade-up" data-aos-duration="500" data-aos-delay="100">
                <?php echo e(json_decode($country->features_manager)[0]->title); ?></h4>

            <div class="row mt-4">
                <?php $__currentLoopData = json_decode($country->features_manager)[0]->properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-12 col-md-4 mb-4 mb-md-0" data-aos="flip-right" data-aos-duration="500"
                    data-aos-delay="200">
                    <div class="card p-4 custom-shadow border-0 tab-card-height">
                        <a href="<?php echo e(route('frontend.individual-property', $prop)); ?>"><img
                                src="<?php echo e(url('image_assest', App\Models\Properties::where('id', $prop)->first()->feature_image_id)); ?>"
                                class="card-img-top w-100" alt="..." style="object-fit:cover; height:210px;"></a>
                        <div class="card-body mt-4">
                            <h5 class="card-title"><?php echo e(App\Models\Properties::where('id', $prop)->first()->name); ?></h5>
                            <p class="card-text mt-3 mb-1">Transaction Type:
                                <?php echo e(App\Models\Properties::where('id', $prop)->first()->transaction_type); ?></p>
                            <p class="card-text">Country:
                                <?php echo e(App\Models\Properties::where('id', $prop)->first()->country); ?></p>

                            <?php if(get_country_cookie(request())): ?>
                            <p class="mt-1 text-info">
                                <?php echo e(current_price(request(), get_country_cookie(request())->country_id, App\Models\Properties::where('id', $prop)->first()->price)); ?>

                            </p>

                            <?php else: ?>
                            <p class="mt-1 text-info">
                                <?php echo e(current_price(request(), 1, App\Models\Properties::where('id', $prop)->first()->price)); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>



        <?php if(json_decode($country->features_manager)[1]->properties != null): ?>
        <div class="home-featured" style="margin-top: 6rem">
            <h4 data-aos="fade-up" data-aos-duration="500" data-aos-delay="100">
                <?php echo e(json_decode($country->features_manager)[1]->title); ?></h4>


            <div class="row mt-4">
                <?php $__currentLoopData = json_decode($country->features_manager)[1]->properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-12 col-md-4 mb-4 mb-md-0" data-aos="flip-right" data-aos-duration="500"
                    data-aos-delay="200">
                    <div class="card p-4 custom-shadow border-0 tab-card-height">

                        <a href="<?php echo e(route('frontend.individual-property', $prop)); ?>"><img
                                src="<?php echo e(url('image_assest', App\Models\Properties::where('id', $prop)->first()->feature_image_id)); ?>"
                                class="card-img-top w-100" alt="..." style="object-fit:cover; height:210px;"></a>
                        <div class="card-body mt-4">
                            <h5 class="card-title"><?php echo e(App\Models\Properties::where('id', $prop)->first()->name); ?></h5>
                            <p class="card-text mt-3 mb-1">Transaction Type:
                                <?php echo e(App\Models\Properties::where('id', $prop)->first()->transaction_type); ?></p>
                            <p class="card-text">Country:
                                <?php echo e(App\Models\Properties::where('id', $prop)->first()->country); ?></p>

                            <?php if(get_country_cookie(request())): ?>
                            <p class="mt-1 text-info">
                                <?php echo e(current_price(request(), get_country_cookie(request())->country_id, App\Models\Properties::where('id', $prop)->first()->price)); ?>

                            </p>

                            <?php else: ?>
                            <p class="mt-1 text-info">
                                <?php echo e(current_price(request(), 1, App\Models\Properties::where('id', $prop)->first()->price)); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>
        <?php endif; ?>

    </div>
</section>



<!--Properties Recently Sold-->
<?php if(get_country_cookie(request())): ?>

<?php if(App\Models\Properties::where('country',get_country_cookie(request())->country_name)->where('sold_request','Sold')->where('admin_approval','Approved')->where('country_manager_approval','=','Approved')->first()
== null): ?>

<?php else: ?>
<!--recent projects-->
<section id="index-recent-projects" class="mt-5">

    <h3 class="text-center fw-bolder" data-aos="fade-up" data-aos-duration="500">Properties Recently Sold</h3>

    <div class="container text-center p-0 mt-3">


        <div class="tab-content mt-md-5 py-0" id="tabs-tabContent">

            <div class="tab-pane fade show active" id="tab-all" role="tabpanel" aria-labelledby="all-tab">

                <div class="swiper container mySwiper" data-aos="fade-up" data-aos-duration="500">
                    <div class="swiper-wrapper mobile-vertical-wrapper">

                        <?php $__currentLoopData = $sold_prop; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $sold): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <?php if(get_country_cookie(request())->country_name == $sold->country): ?>

                        <div class="swiper-slide">
                            <div class="card">
                                <div class="card-body">
                                    <a href="<?php echo e(route('frontend.individual-property', $sold->id)); ?>"
                                        style="text-decoration:none">
                                        <img src="<?php echo e(url('image_assest',$sold->feature_image_id)); ?>" class="img-fluid"
                                            alt="" style="object-fit:cover; height: 210px;">
                                        <h4 class="mt-3"><?php echo e($sold->name); ?></h4>
                                        <p class="mt-2"
                                            style="overflow: hidden; text-overflow: ellipsis; display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical;">
                                            <?php echo e($sold->description); ?></p>
                                        <div class="ribbon ribbon-top-right"><span>Sold</span></div>
                                    </a>
                                </div>
                            </div>
                        </div>

                        <?php endif; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                    <div class="swiper-pagination"></div>
                </div>

            </div>

        </div>
    </div>
</section>

<?php endif; ?>

<?php else: ?>

<h1 class="tab-mt-30" align="center">Select a Country</h1>

<?php endif; ?>




<!--bottom banner-->
<section id="index-bottom-banner">
    <div class="container-fluid bottom-banner" style="margin-top:5rem">
        <div class="container">
            <div class="row justify-content-end text" style="padding-top: 7rem">
                <div class="col-12 col-md-4">
                    <div class="p-3 text-white rounded" style="background: rgba(0, 0, 0, .7)">
                        <h5 data-aos="fade-up" data-aos-duration="500">"I'm so pleased I chose <br> <span
                                class="fw-bolder">Tropical Property!</span> <br> My property was a great valuation <br>
                            and sold quickly, the perfect outcome"</h5>
                        <div class="stars mt-1">
                            <i class="bi bi-star-fill me-2 bottom-banner-stars" data-aos="zoom-out"
                                data-aos-duration="500" data-aos-delay="200"></i>
                            <i class="bi bi-star-fill me-2 bottom-banner-stars" data-aos="zoom-out"
                                data-aos-duration="500" data-aos-delay="300"></i>
                            <i class="bi bi-star-fill me-2 bottom-banner-stars" data-aos="zoom-out"
                                data-aos-duration="500" data-aos-delay="400"></i>
                            <i class="bi bi-star-fill me-2 bottom-banner-stars" data-aos="zoom-out"
                                data-aos-duration="500" data-aos-delay="500"></i>
                            <i class="bi bi-star-fill me-2 bottom-banner-stars" data-aos="zoom-out"
                                data-aos-duration="500" data-aos-delay="600"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<!-- Filter Modal -->
<?php echo $__env->make('frontend.includes.search_filter_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php $__env->stopSection(); ?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/1.0.1/tailwind.min.css"></link>


<?php $__env->startPush('before-scripts'); ?>
<script>


// $( ".imgmap" ).mouseover(function() {
  
   
//   var property_id = $(this).attr("data-id");



//   $.ajax({
//   url: '/mousehover/'+property_id,
//   type: 'GET',
//   dataType: 'json', 
         
          
//         beforeSend: function (request) {
//         return request.setRequestHeader('X-CSRF-Token', $("meta[name='csrf-token']").attr('content'));


//          },
//           success:function(data)  
//           { 
              
          
            

// var latlng = new google.maps.LatLng(data.lat,data.long);



// var myOptions = {
//     zoom: 12,
//     center: latlng,
//     mapTypeId: google.maps.MapTypeId.ROADMAP
// };

// const svgMarker = {
//     path: "M10.453 14.016l6.563-6.609-1.406-1.406-5.156 5.203-2.063-2.109-1.406 1.406zM12 2.016q2.906 0 4.945 2.039t2.039 4.945q0 1.453-0.727 3.328t-1.758 3.516-2.039 3.070-1.711 2.273l-0.75 0.797q-0.281-0.328-0.75-0.867t-1.688-2.156-2.133-3.141-1.664-3.445-0.75-3.375q0-2.906 2.039-4.945t4.945-2.039z",
//     fillColor: "blue",
//     fillOpacity: 0.6,
//     strokeWeight: 0,
//     rotation: 0,
//     scale: 2,
//     id: "mrc",
//     anchor: new google.maps.Point(15, 30),
//   };

// map = new google.maps.Map(document.getElementById("map"), myOptions);
// const marker = new google.maps.Marker
// (
//     {
//         icon: svgMarker,
//         position: new google.maps.LatLng(latlng),
//         map: map,
//         title: 'Click me'
//     }

// );




// marker.addListener("click", () => {
   
//     const infoWindow = new google.maps.InfoWindow();





// var immg = "<?php echo e(url('/')); ?>/image_assest/"+data.image+"";


//     const details = `<body  style="" class="antialiased bg-gray-200 font-sans">
//     <div  class="flex items-center justify-center min-h-screen" style="min-height: 52vh;">
//         <div class="max-w-md md:max-w-2xl px-2" style="margin-bottom: 123px;">
//             <div  class="bg-white shadow-xl rounded-lg overflow-hidden md:flex">
//                 <div class="bg-cover bg-bottom h-56 md:h-auto md:w-56" style="background-image: url('`+immg+`')">
//                 </div>
//                 <div>
//                     <div class="p-4 md:p-5">
//                         <p style="margin-bottom :10px;" class="font-bold text-xl md:text-2xl">`+data.name+` For  <span>`+data.type+`</span></p>
//                        <span><i style="color: #36cb86;" class="bi bi-geo-alt-fill"></i>`+data.city+` , `+data.country+`</span>&nbsp;  <span><i style="color: #7b9be3;" class="bi bi-calendar-fill"></i>  `+data.date+`</span>
//                     </div>
//                     <div class="p-4 md:p-5 bg-gray-100">
//                         <div class="sm:flex sm:justify-between sm:items-center">
//                             <div>
//                                 <div class="text-lg text-gray-700">Asking: <span class="text-gray-900 font-bold" style="color: #ef884b;">USD</span>`+data.price+`</div>
//                                 <div class="flex items-center">
//                                     <div class="flex inline-flex -mx-px">
                                       
//                                     </div>
                                   
//                                 </div>
//                             </div>
//                            <a href="<?php echo e(url('/')); ?>/individual-property/`+property_id+`"> <button style="    padding-right: 1rem!important;
//     padding-left: 1rem!important;" class="mt-3 sm:mt-0 py-2 px-5 md:py-3 md:px-6 bg-indigo-700 hover:bg-indigo-600 font-bold text-white md:text-lg rounded-lg shadow-md">View</button></a>
//                         </div>
//                         <div class="mt-3 text-gray-600 text-sm md:text-base">*Prices may vary depending on selected date.</div>
//                     </div>
//                 </div>
//             </div>
//         </div>
//     </div>
// </body>`;

//     infoWindow.open(map, marker);
//             infoWindow.setContent(details);

    
   
//   });





  
             
//           }  
//      }); 



// });














$( ".save" ).click(function() {
  
   
  var property_id = $(this).attr("data-id");



  var status =  $("#favourite").val();

  $.ajax({  
          url: "<?php echo e(route('frontend.favourite_heart')); ?>",
          method:"POST",  
          data:{property_id: property_id, status: status},  
          dataType:"json", 
          
        beforeSend: function (request) {
        return request.setRequestHeader('X-CSRF-Token', $("meta[name='csrf-token']").attr('content'));
        $("#save").css({"font-size":"2rem"})

         },
          success:function(data)  
          {  
            $(".save[data-id="+ property_id +"]").hide();
            $(".unsave[data-id="+ property_id +"]").show();
          


          }  
     }); 



});

$( ".unsave" ).click(function() {
  
   
  var property_id = $(this).attr("data-id")

  var status =  $("#unfavourite").val();

  $.ajax({  
          url: "<?php echo e(route('frontend.favourite_heart')); ?>",
          method:"POST",  
          data:{property_id: property_id, status: status},  
          dataType:"json", 
          
        beforeSend: function (request) {
        return request.setRequestHeader('X-CSRF-Token', $("meta[name='csrf-token']").attr('content'));


         },
          success:function(data)  
          {  
            $(".save[data-id="+ property_id +"]").show();
            $(".unsave[data-id="+ property_id +"]").hide();
            
             
          }  
     }); 



});



function myFunction($id) {
       
    $.ajax({
  url: '/mousehover/'+$id,
  type: 'GET',
  dataType: 'json', 
         
          
        beforeSend: function (request) {
        return request.setRequestHeader('X-CSRF-Token', $("meta[name='csrf-token']").attr('content'));


         },
          success:function(data)  
          { 

var latlng = new google.maps.LatLng(data.lat,data.long);


        const details = `<div class="modal id="largeModal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content" style="    top: -83px;
    position: absolute;
    width: 215%;
    left: -388px;">
     
    <div class="container">
    <div class="col-lg-8 border p-3 main-section bg-white">
        <div class="row hedding m-0 pl-3 pt-0 pb-3">
        ` +data.name+`
        </div>
        <div class="row m-0">
            <div class="col-lg-4 left-side-product-box pb-3">
                <img src="<?php echo e(url('/')); ?>/image_assest/` +data.image+`" class="border p-3">
                <span class="sub-img">
                    
                    
                </span>
            </div>
            <div class="col-lg-8">
                <div class="right-side-pro-detail border p-3 m-0">
                    <div class="row">
                        <div class="col-lg-12">
              
                            <p class="m-0 p-0"><i style="color: #36cb86;" class="bi bi-geo-alt-fill"></i>  ` +data.city+`,` +data.country+`</p>
                        </div>
                        <div class="col-lg-12">
                            <p class="m-0 p-0 price-pro">$` +data.price+`</p>
                            <hr class="p-0 m-0">
                        </div>
                        <div class="col-lg-12 pt-2">
                            <h5>Detail</h5>
                            <span>` +data.description+`</span>
                            <hr class="m-0 pt-2 mt-2">
                        </div>
                        <div class="col-lg-12">
                           
                        </div>
                     
                        <div class="col-lg-12 mt-3">
                            <div class="row">
                                <div class="col-lg-6 pb-2">
                                    <a href="#" class="btn btn-danger w-100">Email Agent</a>
                                </div>
                                <div class="col-lg-6">
                                    <a href="#" class="btn btn-success w-100">Book a Viewing</a>
                                </div>

    <div> 
    <object type="text/html" data="https://maps.googleapis.com/maps/vt?pb=!1m5!1m4!1i8!2i184!3i122!4i256!2m3!1e0!2sm!3i597327944!3m12!2sen-US!3sUS!5e18!12m4!1e68!2m2!1sset!2sRoadmap!12m3!1e37!2m1!1ssmartmaps!4e0!23i1379903&amp;key=AIzaSyAEBj8LhHUJaf2MXpqIQ_MOXs7HkeUXnac&amp;token=85957" width="600px" height="200px" style="overflow:auto;border:1px solid">
    </object>
</div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12 text-center pt-3">
                <h4>More Product</h4>
            </div>
        </div>
        <div class="row mt-3 p-0 text-center pro-box-section">
            <div class="col-lg-3 pb-2">
                <div class="pro-box border p-0 m-0">
                    <img src="http://nicesnippets.com/demo/pd-b-image1.jpg">
                </div>
            </div>
            <div class="col-lg-3 pb-2">
                <div class="pro-box border p-0 m-0">
                    <img src="http://nicesnippets.com/demo/pd-b-images2.jpg">
                </div>
            </div>
            <div class="col-lg-3 pb-2">
                <div class="pro-box border p-0 m-0">
                    <img src="http://nicesnippets.com/demo/pd-b-images3.jpg">
                </div>
            </div>
            <div class="col-lg-3 pb-2">
                <div class="pro-box border p-0 m-0">
                    <img src="http://nicesnippets.com/demo/pd-b-images4.jpg">
                </div>
            </div>
        </div>
    </div>
</div>

    
    </div>
  </div>
</div>`;

$(details).modal('show');

            // infoWindow.open(map, marker);
            //  infoWindow.setContent(details);
            
          }

        });


}





let lat = <?php echo json_encode($country->latitude); ?>;
let lng = <?php echo json_encode($country->longitude); ?>;



function bigImg(id) {
    


    const labels = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    const infoWindow = new google.maps.InfoWindow();

    const svgMarker2 = {
    path: "M10.453 14.016l6.563-6.609-1.406-1.406-5.156 5.203-2.063-2.109-1.406 1.406zM12 2.016q2.906 0 4.945 2.039t2.039 4.945q0 1.453-0.727 3.328t-1.758 3.516-2.039 3.070-1.711 2.273l-0.75 0.797q-0.281-0.328-0.75-0.867t-1.688-2.156-2.133-3.141-1.664-3.445-0.75-3.375q0-2.906 2.039-4.945t4.945-2.039z",
    fillColor: "black",
    fillOpacity: 0.9,
    strokeWeight: 0,
    rotation: 0,
    scale: 3,
    id: "mrc",
    anchor: new google.maps.Point(15, 30),
  };


    const markers = locations.map((location, i) => {
     
        const marker =  new google.maps.Marker({
            icon: svgMarker2,
            position: location,
            label: labels[i % labels.length]
        });
        


        var nameList = [
            
            <?php $__currentLoopData = $promo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            { 
                id: <?php echo e($crom->id); ?>, 
         
            },
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ];

        const mmid =nameList[i].id;

        if(id==mmid){
            alert(mmid);
            
   
           
            return marker;
           
        }
    
    // 

});

       }



function initMap() {
    const map = new google.maps.Map(document.getElementById("map"), {
        zoom: 7,
        center: {
            lat: parseInt(lat),
            lng: parseInt(lng)
        },
    });

    const labels = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    const infoWindow = new google.maps.InfoWindow();

    const svgMarker = {
    path: "M10.453 14.016l6.563-6.609-1.406-1.406-5.156 5.203-2.063-2.109-1.406 1.406zM12 2.016q2.906 0 4.945 2.039t2.039 4.945q0 1.453-0.727 3.328t-1.758 3.516-2.039 3.070-1.711 2.273l-0.75 0.797q-0.281-0.328-0.75-0.867t-1.688-2.156-2.133-3.141-1.664-3.445-0.75-3.375q0-2.906 2.039-4.945t4.945-2.039z",
    fillColor: "blue",
    fillOpacity: 0.9,
    strokeWeight: 0,
    rotation: 0,
    scale: 3,
    id: "mrc",
    anchor: new google.maps.Point(15, 30),
  };

    const markers = locations.map((location, i) => {

        const marker =  new google.maps.Marker({
            icon: svgMarker,
            position: location,
            label: labels[i % labels.length]
        });



        marker.addListener("click", () => {
            

        var nameList = [
            
            <?php $__currentLoopData = $promo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            { 
                id: <?php echo e($crom->id); ?>, 
                name: "<?php echo e($crom->name); ?>",
                price: "<?php echo e($crom->price); ?>",
                city: "<?php echo e($crom->city); ?>",
                country: "<?php echo e($crom->country); ?>",
                date: " <?php echo e($crom->created_at->diffForHumans()); ?>",
                transaction_type: "<?php echo e($crom->transaction_type); ?>",
               
                imgUrl: "<?php echo e(url('/')); ?>/image_assest/<?php echo e($crom->feature_image_id); ?>",
            },
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            

        ];

       


        const details = ` <body  style="" class="antialiased bg-gray-200 font-sans">
    <div  class="flex items-center justify-center min-h-screen" style="min-height: 52vh;">
        <div class="max-w-md md:max-w-2xl px-2" style="margin-bottom: 123px;">
            <div  class="bg-white shadow-xl rounded-lg overflow-hidden md:flex">
                <div class="bg-cover bg-bottom h-56 md:h-auto md:w-56" style="background-image: url('${nameList[i].imgUrl}')">
                </div>
                <div>
                    <div class="p-4 md:p-5">
                        <p style="margin-bottom :10px;" class="font-bold text-xl md:text-2xl">${nameList[i].name} For <span>${nameList[i].transaction_type}</span></p>
                       <span><i style="color: #36cb86;" class="bi bi-geo-alt-fill"></i> ${nameList[i].city}, ${nameList[i].country}</span>&nbsp;  <span><i style="color: #7b9be3;" class="bi bi-calendar-fill"></i>  ${nameList[i].date}</span>
                    </div>
                    <div class="p-4 md:p-5 bg-gray-100">
                        <div class="sm:flex sm:justify-between sm:items-center">
                            <div>
                                <div class="text-lg text-gray-700">Asking: <span class="text-gray-900 font-bold" style="color: #ef884b;">USD</span>${nameList[i].price}</div>
                                <div class="flex items-center">
                                    <div class="flex inline-flex -mx-px">
                                       
                                    </div>
                                   
                                </div>
                            </div>
                            <button onclick="myFunction(${nameList[i].id})" style="padding-right: 1rem!important;padding-left: 1rem!important;" class="mt-3 sm:mt-0 py-2 px-5 md:py-3 md:px-6 bg-indigo-700 hover:bg-indigo-600 font-bold text-white md:text-lg rounded-lg shadow-md btnview">View</button>
                        </div>
                        <div class="mt-3 text-gray-600 text-sm md:text-base">*Prices may vary depending on selected date.</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>`;



            infoWindow.open(map, markers[i]);
            infoWindow.setContent(details);
        
        });





        return marker;
    
    });



    var markerCluster = new MarkerClusterer(map, markers, {
        imagePath: 'https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/m'
    });

    // let property = <?php echo json_encode($promo); ?>;



    // var infowindow = new google.maps.InfoWindow();

    // for(let i = 0; i < markers.length; i++) {
    //     for(let j = 0; j < property.length; j++) {
    //         let lat = markers[i].getPosition().lat();    
    //         let lng = markers[i].getPosition().lng();   


    //         if(lat == property[j]['lat'] && lng == property[j]['long']) {
    //             let details = `<div class="row align-items-center p-1" style="width: 500px;">
    //                             <div class="col-6">
    //                                 <img src="<?php echo e(url('/')); ?>/image_assest/${property[j]['feature_image_id']}" alt="" class="img-fluid" style="height: 150px!important; object-fit: cover!important; width: 100%";>
    //                             </div>
    //                             <div class="col-6">
    //                                 <h5 class="fw-bold mb-2">${property[j]['name']}</h5>
    //                                 <p class="mb-1" style="font-size: 0.8rem;">Transaction Type: ${property[j]['transaction_type']}</p>
    //                                 <p class="mb-1" style="font-size: 0.8rem;">Country: ${property[j]['country']}</p>
    //                                 <p class="mb-0 d-inline-block px-2 py-1 mt-2 text-light" style="font-size: 0.8rem; background: #4195e1; border-radius: 7px;">Price : ${property[j]['price']}</p>

    //                                 <div class="text-end">
    //                                     <a href="<?php echo e(url('/')); ?>/individual-property/${property[j]['id']}" class="btn px-3 rounded-0 text-light py-1" style="background-color: #4195E1">VIEW</a>
    //                                 </div>
    //                             </div>
    //                         </div>`;

    //             markers[i].addListener('click', function() {
    //                 infowindow.setContent(details);           
    //                 infowindow.open(map, markers[i]);
    //             });
    //         }

    //     };
    // };



   
   

    google.maps.event.addListener(markerCluster, 'click', function(c) {

        var markers = c.getMarkers();
        var newArray = [];

        <?php if(get_country_cookie(request())): ?>
        let country_id = <?php echo json_encode(get_country_cookie(request())->country_id); ?>;
        <?php else: ?>
        let country_id = 1;
        <?php endif; ?>

        for (marker in markers) {
            const cars = [];
            cars['lat'] = markers[marker].getPosition().lat();
            cars['long'] = markers[marker].getPosition().lng();
            newArray.push(JSON.stringify(Object.assign({}, cars)));
        }

        myArray = JSON.stringify(Object.assign({}, newArray));

        $.post("<?php echo e(url('/')); ?>/api/country_request", {
                coordinate_data: myArray,
                country_id: country_id
            },
            function(data, status) {

                var obj = JSON.parse(data);

                let template = '';
                let info = [];

                for (let i = 0; i < obj.length; i++) {

                    info[i] = [obj[i]['country'], obj[i]['long'], obj[i]['lat']];;
                }


                // var infowindow = new google.maps.InfoWindow();


                // for (let i = 0; i < obj.length; i++) {
                //     let details;
                //     markers[i].addListener('click', function() {
                //         if (info[i][1] == markers[i].getPosition().lng() && info[i][2] == markers[i]
                //             .getPosition().lat()) {
                //             details = `  <div class="row align-items-center p-1" style="width: 500px;">
                //                                     <div class="col-6">
                //                                         <img src="<?php echo e(url('/')); ?>/image_assest/${obj[i]['feature_image_id']}" alt="" class="img-fluid" style="height: 150px!important; object-fit: cover!important; width: 100%";>
                //                                     </div>
                //                                     <div class="col-6">
                //                                         <h5 class="fw-bold mb-2">${obj[i]['name']}</h5>
                //                                         <p class="mb-1" style="font-size: 0.8rem;">Transaction Type: ${obj[i]['transaction_type']}</p>
                //                                         <p class="mb-1" style="font-size: 0.8rem;">Country: ${obj[i]['country']}</p>
                //                                         <p class="mb-0 d-inline-block px-2 py-1 mt-2 text-light" style="font-size: 0.8rem; background: #4195e1; border-radius: 7px;">Price : ${obj[i]['price_currency']}</p>

                //                                         <div class="text-end mt-2">
                //                                             <a href="<?php echo e(url('/')); ?>/individual-property/${obj[i]['id']}" class="btn px-3 rounded-0 text-light py-1" style="background-color: #4195E1">VIEW</a>
                //                                         </div>
                //                                     </div>
                //                                 </div>`;

                //             infowindow.setContent(details);
                //             infowindow.open(map, markers[i]);
                //         }
                //     });
                // }



                for (let i = 0; i < obj.length; i++) {

                    let date = obj[i]['created_at'].split(' ')[0];

                    if(obj[i]['is_favourite'] == true){

                        template += '<div class="row border align-items-center p-1">' + 
                                    '<div class="col-6">' +
                                        '<a href="<?php echo e(url('/')); ?>/individual-property/'+ obj[i]['id'] +'"><img src="<?php echo e(url('/')); ?>/image_assest/'+ obj[i]['feature_image_id'] +'" alt="" class="img-fluid" style="height: 90px!important; object-fit: cover!important; width: 100%";></a>' +
                                    '</div>' +
                                    '<div class="col-6">' +
                                        '<div class="row justify-content-between align-items-center">' +
                                            '<div class="col-8">' +
                                                '<p class="mb-0 small-num" style="font-size: 0.7rem;">'+ date +'</p>' +
                                            '</div>' +
                                            '<div class="col-4 small-heart">' +
                                                '<form action="<?php echo e(url('/')); ?>/favourite_cookie/store" method="post" enctype="multipart/form-data">' +
                                                '<?php echo e(csrf_field()); ?>' +
                                                    '<input type="hidden" name="cookie_property_id" value="'+ obj[i]['id'] +'" />' +
                                                    '<button class="bi bi-heart border-0" type="submit" style="font-size: 1rem; display: block; color: #ff0000; background-color: transparent;"></button>' +
                                                '</form>' +                                                        
                                            '</div>' +
                                        '</div>' +                                        
                                        '<p class="fw-bold mb-0">'+ obj[i]['name'] +'</p>' +
                                        '<p class="mb-0" style="font-size: 0.8rem;">Transaction Type: '+ obj[i]['transaction_type'] +'</p>' +
                                        '<p class="mb-0" style="font-size: 0.8rem;">Country: '+ obj[i]['country'] +'</p>' +
                                        '<p class="mb-0 d-inline-block px-2 py-1 mt-2 text-light mb-1" style="font-size: 0.8rem; background: #4195e1; border-radius: 7px;">'+ obj[i]['price_currency'] +'</p>' +
                                    '</div>' +
                                '</div>'

                    }else{

                        template += '<div class="row border align-items-center p-1">' + 
                                    '<div class="col-6">' +
                                        '<a href="<?php echo e(url('/')); ?>/individual-property/'+ obj[i]['id'] +'"><img src="<?php echo e(url('/')); ?>/image_assest/'+ obj[i]['feature_image_id'] +'" alt="" class="img-fluid" style="height: 90px!important; object-fit: cover!important; width: 100%";></a>' +
                                    '</div>' +
                                    '<div class="col-6">' +
                                        '<div class="row justify-content-between align-items-center">' +
                                            '<div class="col-8">' +
                                                '<p class="mb-0 small-num" style="font-size: 0.7rem;">'+ date +'</p>' +
                                            '</div>' +
                                            '<div class="col-4 small-heart">' +
                                                '<form action="<?php echo e(url('/')); ?>/favourite_cookie/store" method="post" enctype="multipart/form-data">' +
                                                '<?php echo e(csrf_field()); ?>' +
                                                    '<input type="hidden" name="cookie_property_id" value="'+ obj[i]['id'] +'" />' +
                                                    '<button class="bi bi-heart border-0" type="submit" style="font-size: 1rem; display: block; color: #ff0000; background-color: transparent;"></button>' +
                                                '</form>' +                                                        
                                            '</div>' +
                                        '</div>' +                                       
                                        '<p class="fw-bold mb-0">'+ obj[i]['name'] +'</p>' +
                                        '<p class="mb-0" style="font-size: 0.8rem;">Transaction Type: '+ obj[i]['transaction_type'] +'</p>' +
                                        '<p class="mb-0" style="font-size: 0.8rem;">Country: '+ obj[i]['country'] +'</p>' +
                                        '<p class="mb-0 d-inline-block px-2 py-1 mt-2 text-light mb-1" style="font-size: 0.8rem; background: #4195e1; border-radius: 7px;">'+ obj[i]['price_currency'] +'</p>' +
                                    '</div>' +
                                '</div>'

                    }

                    
                };


                $(".properties").html(template);
                heart_toggle();

            });
    });


}

const locations = [
    <?php $__currentLoopData = $promo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
         { lat: <?php echo e($prom->lat); ?>, lng: <?php echo e($prom->long); ?> },
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
];



function heart_toggle() {
    $('.small-heart').on('click', function() {
        $(".small-heart bi-heart").hide();
        $(".small-heart bi-heart-fill").show();

        $("i", this).toggle();
    });
    
}




</script>
<?php $__env->stopPush(); ?>



<?php $__env->startPush('after-scripts'); ?>

<script async defer
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAEBj8LhHUJaf2MXpqIQ_MOXs7HkeUXnac&libraries=places&callback=initMap"
    type="text/javascript"></script>


<!-- Swiper JS -->
<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>



<!-- Initialize Swiper -->
<script>
var swiper = new Swiper(".mySwiper", {
    slidesPerView: 3,
    spaceBetween: 30,
    pagination: {
        el: ".swiper-pagination",
        clickable: true,
    },
    breakpoints: {
        0: {
            slidesPerView: 1,
        },

        576: {
            slidesPerView: 3,
        },
        768: {
            slidesPerView: 3,
        }
    },
});

var swiper = new Swiper(".mySwiper2", {
    slidesPerView: 3,
    spaceBetween: 30,
    pagination: {
        el: ".swiper-pagination",
        clickable: true,
    },
});
</script>


<script>
// dropdown box changing field
const renderFields = async () => {
    let value = $('#propertyType').val();

    if (value == '') {


    } else {
        let url = '<?php echo e(url('/')); ?>/api/get_property_type_details/' + value;

        const res = await fetch(url);
        const data = await res.json();
        const fields = (data[0]['activated_fields']);
        let template = '';
        let first = '';
        let second = '';

        for (let i = 0; i < fields.length; i++) {
            if (i == 0) {
                let name = fields[i].split(' ').join('_').toLowerCase();
                if (name == 'beds' || name == 'baths' || name == 'building_type' || name == 'parking_type' ||
                    name == 'zoning_type' || name == 'farm_type') {
                    if (name == 'beds' || name == 'baths') {
                        first = `<div>
                                            <label for="${name}" class="form-label mb-0">${fields[i]}</label>
                                            <select class="form-select" aria-label="${name}" name="${name}" id="${name}">
                                                <option value="">Any</option>
                                                <option value="1">1</option>
                                                <option value="2">2</option>
                                                <option value="3">3</option>
                                                <option value="4">4</option>
                                                <option value="greater-than-5">5+</option>
                                            </select>
                                        </div> `
                    } else if (name == 'building_type') {
                        first = `<div>
                                                        <label for="${name}" class="form-label mb-0">${fields[i]}</label>
                                                        <select class="form-select" aria-label="${name}" id="${name}" name="${name}">
                                                            <option value="">Any</option>
                                                            <option value="house">House</option>
                                                            <option value="row/townhouse">Row / Townhouse</option>
                                                            <option value="apartment">Apartment</option>
                                                            <option value="duplex">Duplex</option>
                                                            <option value="triplex">Triplex</option>
                                                            <option value="fourplex">Fourplex</option>
                                                            <option value="garden-home">Garden Home</option>
                                                            <option value="mobile-home">Mobile Home</option>
                                                            <option value="manufactured-home">Manufactured Home/Mobile</option>
                                                            <option value="special-purpose">Special Purpose</option>
                                                            <option value="residential-commercial-mix">Residential Commercial Mix</option>
                                                            <option value="manufactured-home">Manufactured Home</option>
                                                            <option value="commercial-apartment">Commercial Apartment</option>
                                                            <option value="two-apartment-house">Two Apartment House</option>
                                                            <option value="park-model-mobile-home">Park Model Mobile Home</option>
                                                        </select>
                                                    </div>`
                    } else if (name == 'parking_type') {
                        first = `<div>
                                                    <label for="${name}" class="form-label mb-0">${fields[i]}</label>
                                                    <select class="form-select" name="${name}" aria-label="${name}" id="${name}">
                                                        <option value="">Any</option>
                                                        <option value="boat-house">Boat House</option>
                                                        <option value="concrete">Concrete</option>
                                                        <option value="heated-garage">Heated Garage</option>
                                                        <option value="attached-garage">Attached Garage</option>
                                                        <option value="integrated-garage">Integrated Garage</option>
                                                        <option value="detached-garage">Detached Garage</option>
                                                        <option value="garage">Garage</option>
                                                        <option value="carport">Carport</option>
                                                        <option value="underground">Underground</option>
                                                        <option value="indoor">Indoor</option>
                                                        <option value="open">Open</option>
                                                        <option value="covered">Covered</option>
                                                        <option value="parking-pad">Parking Pad</option>
                                                        <option value="paved-yard">Paved Yard</option>
                                                    </select>
                                                </div>`
                    } else if (name == 'zoning_type') {
                        first = `<div>
                                                    <label for="${name}" class="form-label mb-0">${fields[i]}</label>
                                                    <select class="form-select" name="${name}" aria-label="${name}" id="${name}">
                                                        <option value="">Any</option>
                                                        <option value="commercial-retail">Commercial Retail</option>
                                                        <option value="commercial-office">Commercial Office</option>
                                                        <option value="commercial-mixed">Commercial Mixed</option>
                                                        <option value="industrial">Industrial</option>
                                                        <option value="industrial-light">Industrial-Light</option>
                                                        <option value="industrial-medium">Industrial-Medium</option>
                                                        <option value="industrial-heavy">Industrial-Heavy</option>
                                                        <option value="residential-low-density">Residential-Low Density</option>
                                                        <option value="residential-medium-density">Residential - Medium Density</option>
                                                        <option value="residential-high-density">Residential-High Density</option>
                                                        <option value="institutional">Institutional</option>
                                                        <option value="agricultural">Agricultural</option>
                                                        <option value="recreational">Recreational</option>
                                                        <option value="other">Other</option>
                                                    </select>
                                                </div>`
                    } else if (name == 'farm_type') {
                        first = `<div>
                                                    <label for="${name}" class="form-label mb-0">${fields[i]}</label>
                                                    <select class="form-select" name="${name}" aria-label="${name}" id="${name}">
                                                        <option value="">Any</option>
                                                        <option value="animal">Animal</option>
                                                        <option value="cash-crop">Cash Crop</option>
                                                        <option value="hobby-farm">Hobby Farm</option>
                                                        <option value="market-gardening">Market Gardening</option>
                                                        <option value="nursery">Nursery</option>
                                                        <option value="greenhouse">Greenhouse</option>
                                                        <option value="orchard">Orchard</option>
                                                        <option value="vineyard">Vineyard</option>
                                                        <option value="feed-lot">Feed Lot</option>
                                                        <option value="boarding">Boarding</option>
                                                        <option value="mixed">Mixed</option>
                                                    </select>
                                                </div>`
                    }
                } else {
                    first = `<div>
                                    <label for="${name}" class="form-label mb-0">${fields[i]}</label>
                                    <input type="text" class="form-control" name="${name}" id="${name}" aria-describedby="${name}">
                                </div>`
                }
            } else if (i == 1) {
                let name = fields[i].split(' ').join('_').toLowerCase();
                if (name == 'beds' || name == 'baths' || name == 'building_type' || name == 'parking_type' ||
                    name == 'zoning_type' || name == 'farm_type') {
                    if (name == 'beds' || name == 'baths') {
                        second = `<div>
                                            <label for="${name}" class="form-label mb-0">${fields[i]}</label>
                                            <select class="form-select" aria-label="${name}" name="${name}" id="${name}">
                                                <option value="">Any</option>
                                                <option value="1">1</option>
                                                <option value="2">2</option>
                                                <option value="3">3</option>
                                                <option value="4">4</option>
                                                <option value="greater-than-5">5+</option>
                                            </select>
                                        </div> `
                    } else if (name == 'building_type') {
                        second = `<div>
                                                        <label for="${name}" class="form-label mb-0">${fields[i]}</label>
                                                        <select class="form-select" name="${name}" aria-label="${name}" id="${name}">
                                                            <option value="">Any</option>
                                                            <option value="house">House</option>
                                                            <option value="row/townhouse">Row / Townhouse</option>
                                                            <option value="apartment">Apartment</option>
                                                            <option value="duplex">Duplex</option>
                                                            <option value="triplex">Triplex</option>
                                                            <option value="fourplex">Fourplex</option>
                                                            <option value="garden-home">Garden Home</option>
                                                            <option value="mobile-home">Mobile Home</option>
                                                            <option value="manufactured-home">Manufactured Home/Mobile</option>
                                                            <option value="special-purpose">Special Purpose</option>
                                                            <option value="residential-commercial-mix">Residential Commercial Mix</option>
                                                            <option value="manufactured-home">Manufactured Home</option>
                                                            <option value="commercial-apartment">Commercial Apartment</option>
                                                            <option value="two-apartment-house">Two Apartment House</option>
                                                            <option value="park-model-mobile-home">Park Model Mobile Home</option>
                                                        </select>
                                                    </div>`
                    } else if (name == 'parking_type') {
                        second = `<div>
                                                    <label for="${name}" class="form-label mb-0">${fields[i]}</label>
                                                    <select class="form-select" name="${name}" aria-label="${name}" id="${name}">
                                                        <option value="">Any</option>
                                                        <option value="boat-house">Boat House</option>
                                                        <option value="concrete">Concrete</option>
                                                        <option value="heated-garage">Heated Garage</option>
                                                        <option value="attached-garage">Attached Garage</option>
                                                        <option value="integrated-garage">Integrated Garage</option>
                                                        <option value="detached-garage">Detached Garage</option>
                                                        <option value="garage">Garage</option>
                                                        <option value="carport">Carport</option>
                                                        <option value="underground">Underground</option>
                                                        <option value="indoor">Indoor</option>
                                                        <option value="open">Open</option>
                                                        <option value="covered">Covered</option>
                                                        <option value="parking-pad">Parking Pad</option>
                                                        <option value="paved-yard">Paved Yard</option>
                                                    </select>
                                                </div>`
                    } else if (name == 'zoning_type') {
                        second = `<div>
                                                    <label for="${name}" class="form-label mb-0">${fields[i]}</label>
                                                    <select class="form-select" name="${name}" aria-label="${name}" id="${name}">
                                                        <option value="">Any</option>
                                                        <option value="commercial-retail">Commercial Retail</option>
                                                        <option value="commercial-office">Commercial Office</option>
                                                        <option value="commercial-mixed">Commercial Mixed</option>
                                                        <option value="industrial">Industrial</option>
                                                        <option value="industrial-light">Industrial-Light</option>
                                                        <option value="industrial-medium">Industrial-Medium</option>
                                                        <option value="industrial-heavy">Industrial-Heavy</option>
                                                        <option value="residential-low-density">Residential-Low Density</option>
                                                        <option value="residential-medium-density">Residential - Medium Density</option>
                                                        <option value="residential-high-density">Residential-High Density</option>
                                                        <option value="institutional">Institutional</option>
                                                        <option value="agricultural">Agricultural</option>
                                                        <option value="recreational">Recreational</option>
                                                        <option value="other">Other</option>
                                                    </select>
                                                </div>`
                    } else if (name == 'farm_type') {
                        second = `<div>
                                                    <label for="${name}" class="form-label mb-0">${fields[i]}</label>
                                                    <select class="form-select" name="${name}" aria-label="${name}" id="${name}">
                                                        <option value="">Any</option>
                                                        <option value="animal">Animal</option>
                                                        <option value="cash-crop">Cash Crop</option>
                                                        <option value="hobby-farm">Hobby Farm</option>
                                                        <option value="market-gardening">Market Gardening</option>
                                                        <option value="nursery">Nursery</option>
                                                        <option value="greenhouse">Greenhouse</option>
                                                        <option value="orchard">Orchard</option>
                                                        <option value="vineyard">Vineyard</option>
                                                        <option value="feed-lot">Feed Lot</option>
                                                        <option value="boarding">Boarding</option>
                                                        <option value="mixed">Mixed</option>
                                                    </select>
                                                </div>`
                    }
                } else {
                    second = `<div>
                                    <label for="${name}" class="form-label mb-0">${fields[i]}</label>
                                    <input type="text" class="form-control" name="${name}" id="${name}" aria-describedby="${name}">
                                </div>`
                }
            } else {
                let name = fields[i].split(' ').join('_').toLowerCase();
                if (name == 'beds' || name == 'baths' || name == 'building_type' || name == 'parking_type' ||
                    name == 'zoning_type' || name == 'farm_type') {
                    if (name == 'beds' || name == 'baths') {
                        template += `<div class="col-3">
                                            <label for="${name}" class="form-label mb-0 mt-3">${fields[i]}</label>
                                            <select class="form-select" name="${name}" aria-label="${name}" name="${name}" id="${name}">
                                                <option value="">Any</option>
                                                <option value="1">1</option>
                                                <option value="2">2</option>
                                                <option value="3">3</option>
                                                <option value="4">4</option>
                                                <option value="greater-than-5">5+</option>
                                            </select>
                                        </div> `
                    } else if (name == 'building_type') {
                        template += `<div class="col-3">
                                                        <label for="${name}" class="form-label mb-0 mt-3">${fields[i]}</label>
                                                        <select class="form-select" name="${name}" aria-label="${name}" id="${name}">
                                                            <option value="">Any</option>
                                                            <option value="house">House</option>
                                                            <option value="row/townhouse">Row / Townhouse</option>
                                                            <option value="apartment">Apartment</option>
                                                            <option value="duplex">Duplex</option>
                                                            <option value="triplex">Triplex</option>
                                                            <option value="fourplex">Fourplex</option>
                                                            <option value="garden-home">Garden Home</option>
                                                            <option value="mobile-home">Mobile Home</option>
                                                            <option value="manufactured-home">Manufactured Home/Mobile</option>
                                                            <option value="special-purpose">Special Purpose</option>
                                                            <option value="residential-commercial-mix">Residential Commercial Mix</option>
                                                            <option value="manufactured-home">Manufactured Home</option>
                                                            <option value="commercial-apartment">Commercial Apartment</option>
                                                            <option value="two-apartment-house">Two Apartment House</option>
                                                            <option value="park-model-mobile-home">Park Model Mobile Home</option>
                                                        </select>
                                                    </div>`
                    } else if (name == 'parking_type') {
                        template += `<div class="col-3">
                                                    <label for="${name}" class="form-label mb-0 mt-3">${fields[i]}</label>
                                                    <select class="form-select" name="${name}" aria-label="${name}" id="${name}">
                                                        <option value="">Any</option>
                                                        <option value="boat-house">Boat House</option>
                                                        <option value="concrete">Concrete</option>
                                                        <option value="heated-garage">Heated Garage</option>
                                                        <option value="attached-garage">Attached Garage</option>
                                                        <option value="integrated-garage">Integrated Garage</option>
                                                        <option value="detached-garage">Detached Garage</option>
                                                        <option value="garage">Garage</option>
                                                        <option value="carport">Carport</option>
                                                        <option value="underground">Underground</option>
                                                        <option value="indoor">Indoor</option>
                                                        <option value="open">Open</option>
                                                        <option value="covered">Covered</option>
                                                        <option value="parking-pad">Parking Pad</option>
                                                        <option value="paved-yard">Paved Yard</option>
                                                    </select>
                                                </div>`
                    } else if (name == 'zoning_type') {
                        template += `<div class="col-3">
                                                    <label for="${name}" class="form-label mb-0 mt-3">${fields[i]}</label>
                                                    <select class="form-select" name="${name}" aria-label="${name}" id="${name}">
                                                        <option value="">Any</option>
                                                        <option value="commercial-retail">Commercial Retail</option>
                                                        <option value="commercial-office">Commercial Office</option>
                                                        <option value="commercial-mixed">Commercial Mixed</option>
                                                        <option value="industrial">Industrial</option>
                                                        <option value="industrial-light">Industrial-Light</option>
                                                        <option value="industrial-medium">Industrial-Medium</option>
                                                        <option value="industrial-heavy">Industrial-Heavy</option>
                                                        <option value="residential-low-density">Residential-Low Density</option>
                                                        <option value="residential-medium-density">Residential - Medium Density</option>
                                                        <option value="residential-high-density">Residential-High Density</option>
                                                        <option value="institutional">Institutional</option>
                                                        <option value="agricultural">Agricultural</option>
                                                        <option value="recreational">Recreational</option>
                                                        <option value="other">Other</option>
                                                    </select>
                                                </div>`
                    } else if (name == 'farm_type') {
                        template += `<div class="col-3">
                                                    <label for="${name}" class="form-label mb-0 mt-3">${fields[i]}</label>
                                                    <select class="form-select" name="${name}" aria-label="${name}" id="${name}">
                                                        <option value="">Any</option>
                                                        <option value="animal">Animal</option>
                                                        <option value="cash-crop">Cash Crop</option>
                                                        <option value="hobby-farm">Hobby Farm</option>
                                                        <option value="market-gardening">Market Gardening</option>
                                                        <option value="nursery">Nursery</option>
                                                        <option value="greenhouse">Greenhouse</option>
                                                        <option value="orchard">Orchard</option>
                                                        <option value="vineyard">Vineyard</option>
                                                        <option value="feed-lot">Feed Lot</option>
                                                        <option value="boarding">Boarding</option>
                                                        <option value="mixed">Mixed</option>
                                                    </select>
                                                </div>`
                    }
                } else {
                    template += `<div class="col-3">
                                <div>
                                    <label for="${name}" class="form-label mb-0 mt-3">${fields[i]}</label>
                                    <input type="text" class="form-control" name="${name}" id="${name}" aria-describedby="${name}">
                                </div>
                            </div>`
                }
            }
        }
        $('.first-incoming-field').html(first);
        $('.second-incoming-field').html(second);
        $('#incoming_fields').html(template);
    }
}

// window.addEventListener('DOMContentLoaded', () => renderFields());

$('.filter-button').on('click', function() {
    renderFields();
})

$('.filter-reset').click(function() {
    $('#filter-form')[0].reset();
});
</script>


<!-- <script>
    $('.filter-btn').on('click', function() {
        let value = $(this).siblings('.category').val();

        $('#modal-id').val(value);
    });
</script> -->


<script>
$('.swiper-slide img').on('click', function() {
    let img = $(this).attr('src');
    let link = $(this).next().val();
    let description = $(this).siblings('.ad-description').val();

    $('#modal-ad-img').attr('src', img);
    $('#modal-ad-link').attr('href', link);
    $('#modal-ad-description').text(description);


});
</script>



<?php $__env->startPush('after-scripts'); ?>


<script>
const renderCity = async () => {

    <?php if(get_country_cookie(request())): ?>
    let country_id = <?php echo json_encode(get_country_cookie(request())->country_id); ?>;
    <?php else: ?>
    let country_id = 1;
    <?php endif; ?>

    let countries = <?php echo json_encode($countries); ?>;

    let name;
    let countryName;
    let template;

    for (let i = 0; i < countries.length; i++) {
        if (countries[i]['country_id'] == country_id) {
            name = countries[i]['slug'];
        }
    }

    if (name.includes('-')) {
        countryName = name.replace("-", " ");
    } else {
        countryName = name;
    }


    $.ajax({
        "type": "POST",
        "url": "https://countriesnow.space/api/v0.1/countries/cities",
        "data": {
            "country": countryName
        }
    }).done(function(d) {

        for (let i = 0; i < d['data'].length; i++) {
            template += `
                    <option value="${d['data'][i]}">${d['data'][i]}</option>
                `
        }

        $(".areas").append(template);
    });
}

window.addEventListener('DOMContentLoaded', () => renderCity());
</script>


<script>
(function() {

    if (window.localStorage) {
        if (!localStorage.getItem('firstLoad')) {
            localStorage['firstLoad'] = true;
            window.location.reload();
        } else {
            localStorage.removeItem('firstLoad');
        }
    }

})();






















</script>

<?php $__env->stopPush(); ?>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('frontend.layouts.theme_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\company\TPR\tpr2\tpr\resources\views/frontend/home_page/index.blade.php ENDPATH**/ ?>