<?php $__env->startSection('title', __('Approval')); ?>

<?php $__env->startSection('content'); ?>

<form action="<?php echo e(route('admin.property.update')); ?>" method="post" enctype="multipart/form-data">
        <?php echo e(csrf_field()); ?>

        <div class="row">
            <div class="col-md-7 p-1">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="carousel">
                                    <div id="carouselControls" class="carousel slide" data-bs-ride="carousel">
                                        <div class="carousel-inner">

                                        <?php if($interior_image != NULL): ?>
                                            <?php $__currentLoopData = $interior_image; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $interior): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                    <div class="carousel-item">
                                                        <img src="<?php echo e(url('images', App\Models\FileManager::where('id', $interior)->first()->file_name)); ?>" class="d-block w-100" style="height:370px; object-fit:cover;" alt="...">
                                                    </div>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>

                                        <?php if($images != NULL): ?>
                                            <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <?php if($index == 0): ?>
                                                    <div class="carousel-item active">
                                                        <img src="<?php echo e(url('images', App\Models\FileManager::where('id', $image)->first()->file_name)); ?>" class="d-block w-100" style="height:370px; object-fit:cover;" alt="...">
                                                    </div>
                                                <?php else: ?>
                                                    <div class="carousel-item">
                                                        <img src="<?php echo e(url('images', App\Models\FileManager::where('id', $image)->first()->file_name)); ?>" class="d-block w-100" style="height:370px; object-fit:cover;" alt="...">
                                                    </div>
                                                <?php endif; ?>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>



                                        </div>

                                        <button class="carousel-control-prev" type="button" data-bs-target="#carouselControls" data-bs-slide="prev">
                                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                            <span class="visually-hidden">Previous</span>
                                        </button>
                                        <button class="carousel-control-next" type="button" data-bs-target="#carouselControls" data-bs-slide="next">
                                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                            <span class="visually-hidden">Next</span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row mt-5">
                            <div class="col-12">
                                <div class="row align-items-center">
                                    <div class="col-5">
                                        <h4 class="mb-0"><?php echo e($property->name); ?></h4>
                                    </div>
                                    <div class="col-4">
                                        <?php if($property->virtual_tour != null): ?>
                                            <div class="mt-3">
                                                <a class="btn btn-success text-light mb-2" data-toggle="modal" data-target="#virtual_tour_modal">Virtual Tour</a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-3">
                                        <div class="text-end">
                                            <h5 class="d-inline-block mb-0 py-2 px-4 text-light" style="background-color: #4195E1;"><?php echo e($property_type->property_type_name); ?></h5>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-4 pe-0 align-items-center">
                                <div class="col-6">
                                    <table class="table table-hover table-borderless">
                                        <tbody>
                                            <tr>
                                                <td style="font-weight: 600;">Location</td>
                                                <td><?php echo e($property->city); ?>, <?php echo e($property->country); ?></td>
                                            </tr>
                                            <tr>
                                                <td style="font-weight: 600;">Price</td>
                                                <td><?php echo e($property->price); ?></td>
                                            </tr>
                                            <tr>
                                                <td style="font-weight: 600;">Category</td>
                                                <td><?php echo e($property->main_category); ?></td>
                                            </tr>
                                            <tr>
                                                <td style="font-weight: 600;">Meta Description</td>
                                                <td><?php echo e($property->meta_description); ?></td>
                                            </tr>
                                            <tr>
                                                <td style="font-weight: 600;">Slug</td>
                                                <td><?php echo e($property->slug); ?></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <div class="col-6 pe-0">
                                    <div id="map" style="height: 300px; width: 100%;"></div>
                                    <input type="hidden" name="lat" id="lat" class="mt-3" value="<?php echo e($property->lat); ?>">
                                    <input type="hidden" name="lng" id="lng" class="mt-3" value="<?php echo e($property->long); ?>">
                                    <input type="hidden" name="country" id="country" class="mt-3" value="<?php echo e($property->country); ?>">
                                </div>
                            </div>

                            <div class="row mt-5 pe-0 align-items-center">
                                <div class="col-6">
                                    <table class="table table-hover table-borderless">
                                        <tbody>
                                                <?php if($property->transaction_type == null): ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td style="font-weight: 600;">Transaction Type</td>
                                                        <td><?php echo e($property->transaction_type); ?></td>
                                                    </tr>
                                                <?php endif; ?>

                                                <?php if($property->zoning_type == null): ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td style="font-weight: 600;">Zoning Type</td>
                                                        <td><?php echo e($property->zoning_type); ?></td>
                                                    </tr>
                                                <?php endif; ?>

                                                <?php if($property->building_type == null): ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td style="font-weight: 600;">Building Type</td>
                                                        <td><?php echo e($property->building_type); ?></td>
                                                    </tr>
                                                <?php endif; ?>

                                                <?php if($property->building_size == null): ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td style="font-weight: 600;">Building Size</td>
                                                        <td><?php echo e($property->building_size); ?></td>
                                                    </tr>
                                                <?php endif; ?>

                                                <?php if($property->farm_type == null): ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td style="font-weight: 600;">Farm Type</td>
                                                        <td><?php echo e($property->farm_type); ?></td>
                                                    </tr>
                                                <?php endif; ?>

                                                <?php if($property->beds == null): ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td style="font-weight: 600;">Beds</td>
                                                        <td><?php echo e($property->beds); ?></td>
                                                    </tr>
                                                <?php endif; ?>

                                                <?php if($property->baths == null): ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td style="font-weight: 600;">Baths</td>
                                                        <td><?php echo e($property->baths); ?></td>
                                                    </tr>
                                                <?php endif; ?>

                                                <?php if($property->land_size == null): ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td style="font-weight: 600;">Land Size</td>
                                                        <td><?php echo e($property->land_size); ?></td>
                                                    </tr>
                                                <?php endif; ?>

                                                <?php if($property->number_of_units == null): ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td style="font-weight: 600;">Number Of Units</td>
                                                        <td><?php echo e($property->number_of_units); ?></td>
                                                    </tr>
                                                <?php endif; ?>

                                                <?php if($property->open_house_only == null): ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td style="font-weight: 600;">Open House Only</td>
                                                        <td><?php echo e($property->open_house_only); ?></td>
                                                    </tr>
                                                <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>

                                <div class="col-6 pe-0">
                                    <div class="row justify-content-center">
                                        <div class="col-10">
                                            <div class="card">
                                                <div class="text-center mt-2">
                                                    <?php if(is_company_agency($property->user_id)): ?>
                                                    <?php else: ?>
                                                        <img src="<?php echo e(url('files/agent_request',$agent_details->photo)); ?>" class="rounded-circle card-img-top border border-2" alt="..." style="height: 120px; width: 50%; object-fit:cover">
                                                    <?php endif; ?>

                                                </div>

                                                <div class="card-body">
                                                    <?php if(is_company_agency($property->user_id)): ?>
                                                    <?php else: ?>
                                                        <h5 class="card-title text-center"><?php echo e(App\Models\AgentRequest::where('user_id', $property->user_id)->first()->name); ?></h5>
                                                        <p class="card-text mb-0">Email : <?php echo e(App\Models\AgentRequest::where('user_id', $property->user_id)->first()->email); ?></p>
                                                        <p class="card-text mb-0">Phone : <?php echo e(App\Models\AgentRequest::where('user_id', $property->user_id)->first()->telephone); ?></p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-5 p-1">
                <div class="card">
                    <div class="card-body">
                        <div class="" >
                            <div class="form-group">
                                <label style="font-weight: 600;" class="ml-2">Description:</label>
                                <table class="table table-hover table-borderless">
                                    <tbody>
                                        <tr>
                                            <td><?php echo e($property->description); ?></td>
                                        </tr>
                                        <?php if($property->sold_request == 'Sold'): ?>
                                            <tr>
                                                <td style="font-weight: 600;">Property Sold Status :</td>
                                                <td><?php echo e($property->sold_request); ?></td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if($external_parameter != null): ?>
                    <div class="card">
                        <div class="card-body">
                            <div class="" >
                                <div class="form-group">
                                    <label style="font-weight: 600;" class="ml-2">External Features:</label>
                                    <table class="table table-hover table-borderless">
                                        <tbody>
                                            <?php $__currentLoopData = $external_parameter; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $external): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($external->label); ?> : <?php echo e($external->userData[0]); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-body">
                        <div class="" style="border-style: ridge;border-width: 3px;padding: 20px;">
                            <div class="form-group">
                                <label>Admin Approval</label>
                                <select onchange="dissapproveMsg(value)" class="form-control" name="admin_approval" required>
                                    <option value="Approved" <?php echo e($property->admin_approval == 'Approved' ? "selected" : ""); ?>>Approve</option>
                                    <option value="Disapproved" <?php echo e($property->admin_approval == 'Disapproved' ? "selected" : ""); ?>>Disapprove</option>
                                    <option value="Pending" <?php echo e($property->admin_approval == 'Pending' ? "selected" : ""); ?>>Pending</option>
                                </select>
                            </div>

                            <div style="display:none" class="form-group dissaproveArea">
                                <label>Admin Dissapproval Remark</label>
                                <input class="form-control" name="super_admin_remark" id="txtSuperAdminRemark">
                            </div>

<script>
    function dissapproveMsg(val){
        if(val == "Disapproved"){
            $('.dissaproveArea').show();
            $('#txtSuperAdminRemark').attr('required','required')
        } else {

            $('#txtSuperAdminRemark').removeAttr('required')
            $('.dissaproveArea').hide();
        }
    }
</script>

                            <div class="mt-5 text-center">
                                <input type="hidden" name="hidden_id" value="<?php echo e($property->id); ?>"/>
                                <a href="<?php echo e(route('admin.property.index')); ?>" type="button" class="btn rounded-pill text-light px-4 py-2 me-2 btn-primary">Back</a>
                                <button type="submit" class="btn rounded-pill text-light px-4 py-2 ms-2 btn-success">Update</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <div class="modal fade" id="virtual_tour_modal" tabindex="-1" aria-labelledby="virtual_tour_modalModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="virtual_tour_modalModalLabel">Virtal Tour</h5>
                <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                    <?php echo $property->virtual_tour; ?>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <!-- <button type="button" class="btn btn-primary">Save changes</button> -->
            </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('after-scripts'); ?>

<script>

    let lat = $('#lat').val();
    let lng = $('#lng').val();

    function initMap() {

        const myLatLng = { lat: parseFloat(lat), lng: parseFloat(lng) };
        const map = new google.maps.Map(document.getElementById("map"), {
            zoom: 6,
            center: myLatLng,
        });
        new google.maps.Marker({
            position: myLatLng,
            map,
            title: "Hello World!",
        });

        //   console.log(myLatLng)
}
</script>


<script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAEBj8LhHUJaf2MXpqIQ_MOXs7HkeUXnac&callback=initMap"
type="text/javascript"></script>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cxc/public_html/tprmap.com/resources/views/backend/property/edit.blade.php ENDPATH**/ ?>