

<?php $__env->startSection('title', app_name() . ' | ' . __('navs.frontend.dashboard') ); ?>

<?php $__env->startSection('content'); ?>

<?php $__env->startPush('after-styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('tpr_templete/stylesheets/profile-settings.css')); ?>">
<?php $__env->stopPush(); ?>

    <div class="container user-settings" style="margin-top:8rem; margin-bottom: 5rem;">
        <div class="row justify-content-between">
            <div class="col-4 full-size-width">
                <div class="row">
                    <div class="col-12">
                        <?php echo $__env->make('frontend.includes.profile-settings-links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>

            <div class="col-8 full-size-width">
                <div class="row justify-content-between">
                    <div class="col-12 p-0">
                        <div class="row align-items-center">
                            <div class="col-6 ps-4">
                                <h4 class="fs-4 fw-bolder user-settings-head">My Bookings</h4>
                            </div>
                        </div>
                    </div>
                </div>


                <?php if(count($bookings) == 0): ?>

                    <?php echo $__env->make('frontend.includes.not_found',[
                    'not_found_title' => 'My Booking item Not Found',
                    'not_found_description' => 'My booking item not found.please book agent for get the property',
                    'not_found_button_caption' => 'Explorer Property'
                     ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <?php else: ?>
                    <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row">
                            <div class="col-12">
                                <div class="px-2" id="nav-properties" role="tabpanel" aria-labelledby="nav-properties-tab">
                                    <div class="row align-items-center justify-content-between mb-4 border py-3">

                                        <div class="col-4">
                                            <a href="<?php echo e(route('frontend.individual-property', $booking->property_id)); ?>"><img src="<?php echo e(url('image_assest',\App\Models\Properties::where('id',$booking->property_id)->first()->feature_image_id)); ?>" class="card-img-top" alt="..."></a>
                                        </div>
                                        <div class="col-5">
                                            <h5 class="card-title"><?php echo e(\App\Models\Properties::where('id',$booking->property_id)->first()->name); ?></h5>
                                            <p class="card-text mt-1 mb-1">Country: <?php echo e(\App\Models\Properties::where('id',$booking->property_id)->first()->country); ?></p>
                                            <p class="card-text mb-1">Category: <?php echo e(\App\Models\Properties::where('id',$booking->property_id)->first()->main_category); ?></p>
                                            <!-- <p class="mt-1 text-info">$<?php echo e(number_format(\App\Models\Properties::where('id',$booking->property_id)->first()->price,2)); ?></p> -->
                                            <?php if(get_country_cookie(request())): ?>
                                                <p class="mb-0 d-inline-block px-2 py-1 mt-2 text-light mb-1" style="font-size: 0.8rem; background: #4195e1; border-radius: 7px;"><?php echo e(current_price(request(), get_country_cookie(request())->country_id, App\Models\Properties::where('id',$booking->property_id)->first()->price)); ?></p>
                                            <?php else: ?>
                                                <p class="mb-0 d-inline-block px-2 py-1 mt-2 text-light mb-1" style="font-size: 0.8rem; background: #4195e1; border-radius: 7px;"><?php echo e(current_price(request(), 1, App\Models\Properties::where('id',$booking->property_id)->first()->price,2)); ?></p>
                                            <?php endif; ?>

                                            <div style="background: #b1ecff;color: #000000;padding: 10px;border-radius: 10px;">
                                                <?php echo e($booking->created_at); ?>

                                            </div>
                                            <br>
                                            <div class="row justify-content-between">
                                                <div class="col-12">
                                                    <div class="row justify-content-end">
                                                        <div class="col-4">
                                                            <button  data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo e($booking->id); ?>" class="btn px-3 rounded-0 text-light py-1" style="background-color: #4195E1">Open</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-3">
                                        <!-- <img src="<?php echo e(url('tpr_templete/images/users/user-2.png')); ?>" class="img-fluid border border-2" style="object-fit:cover; width:180px;" alt="..."> -->
                                            <div class="card">
                                                <div class="text-center">
                                                    <img src="<?php echo e(url('files/agent_request',\App\Medels\AgentRequest::where('id',$booking->agent_id)->first()->photo )); ?>" class="rounded-circle card-img-top border border-2 img-fluid mt-2" alt="..." style="height: 6rem; width: 60%">
                                                </div>

                                                <div class="card-body text-center">
                                                    <h5 class="card-title text-center"><?php echo e(\App\Medels\AgentRequest::where('id',$booking->agent_id)->first()->name); ?></h5>
                                                    <p class="card-text mb-0"><?php echo e(\App\Medels\AgentRequest::where('id',$booking->agent_id)->first()->email); ?></p>
                                                    <p class="card-text mb-0"><?php echo e(\App\Medels\AgentRequest::where('id',$booking->agent_id)->first()->telephone); ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <!-- Modal -->
                        <div class="modal fade" id="exampleModal<?php echo e($booking->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel">View Message</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                       <h4>Contact Method: <?php echo e($booking->method_of_contact); ?></h4>

                                       <p class="mb-1">Phone Number: <?php echo e($booking->phone_number); ?></p>
                                       <p class="mb-1">Email: <?php echo e($booking->email); ?></p>
                                    
                                        <p class="mb-1">Im a <?php echo e($booking->im_resident); ?></p>

                                        <p class="mb-1">Booking Date and Time (24 Hours): <?php echo e(date('Y-m-d G:i', strtotime($booking->booking_time))); ?></p>
                                                                              
                                        
                                        <?php if($booking->book_a_viewing == 'No'): ?>
                                        <?php else: ?>
                                            <p>Book a Viewing</p>
                                        <?php endif; ?>


                                        <div class="card">
                                            <div class="card-body">
                                                <?php echo e($booking->message); ?>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>







            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('after-scripts'); ?>


    <script>
        $('.delete').on('click', function() {
            let link = $(this).attr('href');
            $('.modal-footer a').attr('href', link);
        });      
        
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.theme_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cxc/public_html/tprmap.com/resources/views/frontend/user/my-bookings.blade.php ENDPATH**/ ?>