

<?php $__env->startSection('title', app_name() . ' | ' . __('navs.frontend.dashboard') ); ?>

<?php $__env->startSection('content'); ?>

<?php $__env->startPush('after-styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('tpr_templete/stylesheets/profile-settings.css')); ?>">
<?php $__env->stopPush(); ?>

    <div class="container user-settings" style="margin-top:8rem; margin-bottom: 5rem;">
        <div class="row justify-content-between">
            <div class="col-4 full-size-width">
                <div class="row">
                    <div class="col-12">
                        <?php echo $__env->make('frontend.includes.profile-settings-links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>

            <div class="col-8 full-size-width mobile-top-padding">

                <div class="row justify-content-between">
                    <div class="col-8 p-0">
                        <div class="row align-items-center">
                            <div class="col-6 ps-4">
                                <h4 class="fs-4 fw-bolder user-settings-head">Favourite Properties</h4>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-12">
                        <div class="px-2" id="nav-properties" role="tabpanel" aria-labelledby="nav-properties-tab">

                        <?php if(count($favourite) == 0): ?>

                        <?php echo $__env->make('frontend.includes.not_found',[
                            'not_found_title' => 'Favorite item not found',
                            'not_found_description' => 'Favorite item not found.please add Favorite ',
                            'not_found_button_caption' => 'Explorer Property'
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <?php else: ?>
                            <?php if(count($property) != 0): ?>
                                <?php $__currentLoopData = $property; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(is_favorite($prop->id, auth()->user()->id)): ?>
                                        <div class="row align-items-center justify-content-between mb-4 border py-3">
                                            <div class="col-6">
                                                <a href="<?php echo e(route('frontend.individual-property', $prop->id)); ?>"><img src="<?php echo e(url('image_assest', $prop->feature_image_id)); ?>" style="width:350px; object-fit:cover;" height="210px" class="card-img-top" alt="..."></a>
                                            </div>
                                            <div class="col-5">
                                                <h5 class="card-title"><?php echo e($prop->name); ?></h5>
                                                <h6 class="card-title mt-3"><?php echo e($prop->city); ?>, <?php echo e($prop->country); ?></h6>

                                                <?php if($prop->beds == null): ?>
                                                <?php else: ?>
                                                    <p class="card-text mt-3 mb-1">
                                                        <?php echo e($prop->beds); ?> Bed Semidetached house
                                                    </p>
                                                <?php endif; ?>

                                                <!-- <p class="card-text">Lancaster, claited Kingdom</p> -->
                                                <p class="mt-1 text-info">$ <?php echo e($prop->price); ?></p>

                                                <div class="row">
                                                    <div class="col-4">
                                                        <a href="<?php echo e(route('frontend.individual-property', $prop->id)); ?>" class="btn px-4 rounded-0 text-light py-1" style="background-color: #4195E1">View</a>
                                                    </div>
                                                    <div class="col-4">
                                                        <input type="hidden" name="hid_id" value="<?php echo e($prop->id); ?>">
                                                        <a href="<?php echo e(route('frontend.user.favourites-delete', $prop->id)); ?>" class="btn px-4 rounded-0 text-light py-1 delete" data-bs-toggle="modal" data-bs-target="#deleteFavorite" style="background-color: #ff2c4b"><i class="bi bi-trash-fill"></i></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                        
                            <?php endif; ?>
                        <?php endif; ?>



                        <div class="modal fade" id="deleteFavorite" tabindex="-1" aria-labelledby="deleteFavoriteLabel" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel">Delete Property</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        Do you want to delete this from favourite properties?
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                        <a href="" class="btn btn-primary">Delete</a>
                                    </div>
                                </div>
                            </div>
                        </div>                            

                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('after-scripts'); ?>
    <script>
        $('.delete').on('click', function() {
            let link = $(this).attr('href');
            $('.modal-footer a').attr('href', link);
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.theme_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cxc/public_html/tprmap.com/resources/views/frontend/user/favourites.blade.php ENDPATH**/ ?>