<?php

namespace BeyondCode\SelfDiagnosis\Checks;

class DebugModeIsNotEnabled implements Check
{

    /**
     * The name of the check.
     *
     * @param array $config
     * @return string
     */
    public function name(array $config): string
    {
        return trans('self-diagnosis::checks.debug_mode_is_not_enabled.name');
    }

    /**
     * Perform the actual verification of this check.
     *
     * @param array $config
     * @return bool
     */
    public function check(array $config): bool
    {
        return config('app.debug') === false;
    }

    /**
     * The error message to display in case the check does not pass.
     *
     * @param array $config
     * @return string
     */
    public function message(array $config): string
    {
        return trans('self-diagnosis::checks.debug_mode_is_not_enabled.message');
    }
}
